  ' Micromite interface to ILI9488 3.5" 320x480 LCD touch panel
  'same header as current 240x320 2.8" panel, although mounting holes are different
  'many functions working, colours may not be correct
  
  OPTION EXPLICIT
  'MicroMite Plus with LCD backpack
  'interface pins, uses SPI2   (MISO, MOSI, SCLK) and...
  CONST LCDRESET=23
  CONST LCDDC=2
  CONST LCDCS=29
  CONST TOUCHCS=1
  CONST TOUCHIRQ=3
  
  'some colour constants
  CONST LCDBLACK  = &H000000
  CONST LCDRED    = &HFF0000
  CONST LCDGREEN  = &H00FF00
  CONST LCDBLUE   = &H0000FF
  CONST LCDCYAN   = &H00FFFF
  CONST LCDMAGENTA= &HFF00FF
  CONST LCDYELLOW = &HFFFF00
  CONST LCDWHITE  = &HFFFFFF
  
  'handy globals
  DIM INTEGER LCDWIDTH, LCDHEIGHT, LCDROTATION
  DIM INTEGER X,Y
  DIM INTEGER CBUFFER(576)    'for bulk colour transfers, sized to allow a font character to fit
  DIM INTEGER FONTADDRESS
  FONTADDRESS=PEEK(CFUNADDR FONT)
  DIM INTEGER FONTARRAY(24)  'used locally to interpret font data
  'easier than calculating exponents
  DIM INTEGER BITS(8)
  BITS(0)=1
  BITS(1)=2
  BITS(2)=4
  BITS(3)=8
  BITS(4)=16
  BITS(5)=32
  BITS(6)=64
  BITS(7)=128


DIM INTEGER R
R=0
DIM STRING SCREENTEXT

  ''MAIN
  setpin 53 , DOUT    'backlight
  pin(53)=1
  LCDSETUP

DO
  LCDSETROTATION(R)
  LCDCLEAR(LCDBLUE)
  LCDBOX(10,10,140,140,LCDRED)
  SCREENTEXT="Testing:"+str$(R)
    LCDSTRING(20,20,SCREENTEXT,LCDGREEN,LCDBLACK)
  FOR X = 0 to 319
    LCDPOINT(X,X,LCDWHITE)
  NEXT X
  PAUSE 1000
  R=R+1
  IF R>3 THEN R=0
LOOP  
END
  
  ''END OF MAIN

SUB LCDSETUP
  'startup values
  LCDROTATION=0
  LCDWIDTH=320
  LCDHEIGHT=480
  'pin setup
  SETPIN LCDRESET,DOUT
  PIN(LCDRESET)=0
  SETPIN LCDDC,DOUT
  PIN(LCDDC)=1
  SETPIN LCDCS,DOUT
  PIN(LCDCS)=1
  SPI2 OPEN 10000000, 0, 8   'ILI9488 supports up to 50MHz SPI2, limited to 10MHz by Micromite
  PAUSE 120
  PIN(LCDRESET)=1           'out of reset
  PAUSE 120                 'wait
  PIN(LCDCS)=0              'start init codes
  LCDCOMMAND(&H01)          'soft reset
  PAUSE 120
  LCDCOMMAND(&h11)          'sleep out
  PAUSE 120
  LCDCOMMAND(&h13)   ''normal
  LCDCOMMAND(&h20)   ''no inversion
  LCDCOMMAND(&h28)   ''display off
  LCDCOMMAND(&h38)   ''idle mode off
  LCDCOMMAND(&hC0)   ''power control 1
  LCDDATA(&h17)
  LCDDATA(&h15)
  LCDCOMMAND(&hC1)   ''power control 2
  LCDDATA(&h41)
  LCDCOMMAND(&hC5)   ''VCOM control
  LCDDATA(&h0e)
  LCDDATA(&h0e)
  LCDCOMMAND(&h36)   ''Memory Access control
  LCDDATA(88)
  LCDCOMMAND(&h3A)   ''Pixel interface format
  LCDDATA(&h66)
  LCDCOMMAND(&hB4)   ''inversion control
  LCDDATA(&h2)
  LCDCOMMAND(&hB6)   ''Function control
  LCDDATA(&h2)
  LCDDATA(&h2)
  LCDDATA(&h3B)
  LCDCOMMAND(&h29)   ''display on
  LCDCOMMAND(&h2A)   ''set column
  LCDDATA(&h0)
  LCDDATA(&h0)
  LCDDATA(&h1)
  LCDDATA(&h3F)
  LCDCOMMAND(&h2B)   ''set row
  LCDDATA(&h0)
  LCDDATA(&h0)
  LCDDATA(&h1)
  LCDDATA(&hDF)
  LCDCOMMAND(&h2C)   ''draw
  PIN(LCDCS)=1        'release bus
END SUB
  
SUB LCDCOMMAND(D AS INTEGER)    'toggle DC and send data
  PIN(LCDDC)=0
  SPI2 WRITE 1,D
  PIN(LCDDC)=1
  'PRINT "C:";D
END SUB
  
SUB LCDCLEAR(C AS INTEGER)
  LCDBOX(0,0,LCDWIDTH-1,LCDHEIGHT-1,C)
END SUB
  
SUB LCDDATA(D AS INTEGER)
  SPI2 WRITE 1,D
  'PRINT "D:";D
END SUB
  
SUB LCDCOLOUR(C2 AS INTEGER,C1 AS INTEGER,C0 AS INTEGER)   ''sends 3 bytes from a colour (R,G,B)
  SPI2 WRITE 3,C2,C1,C0
END SUB
  
SUB LCDCOLOUR80(CARRAY() AS INTEGER)   'send an array, was 80 now 192 pixels
  SPI2 WRITE 576,CARRAY()
END SUB
  
SUB LCDBOX(X0 AS INTEGER, Y0 AS INTEGER, X1 AS INTEGER, Y1 AS INTEGER, C AS INTEGER)
  LOCAL INTEGER T,X,Y
  LOCAL INTEGER C0,C1,C2
  LOCAL INTEGER PIXELCOUNT
  C2=(C\65536)AND 255     'calculate here
  C1=(C\256)AND 255
  C0=C AND 255
  IF X1<X0 THEN     ''need to sort for our own loops
    T=X0
    X0=X1
    X1=T
  ENDIF
  IF Y1<Y0 THEN
    T=Y0
    Y0=Y1
    Y1=T
  ENDIF
  PIXELCOUNT = (X1-X0+1)*(Y1-Y0+1)
  FOR T=0 to 573 STEP 3
    CBUFFER(T)=C2
    CBUFFER(T+1)=C1
    CBUFFER(T+2)=C0
  NEXT T
  LCDSETAREA(X0,Y0,X1,Y1)
  PIN(LCDCS)=0        'assert bus
  WHILE PIXELCOUNT>192
    PIXELCOUNT=PIXELCOUNT-192
    LCDCOLOUR80(CBUFFER())
  WEND
  FOR T= 1 to PIXELCOUNT
    LCDCOLOUR(C2,C1,C0)
  NEXT T
  PIN(LCDCS)=1        'release bus
END SUB
  
SUB LCDSETAREA(X0 AS INTEGER, Y0 AS INTEGER, X1 AS INTEGER, Y1 AS INTEGER)    'set drawing area for most other routines
  LOCAL INTEGER T
  IF X1<X0 THEN
    T=X0
    X0=X1
    X1=T
  ENDIF
  IF Y1<Y0 THEN
    T=Y0
    Y0=Y1
    Y1=T
  ENDIF
  PIN(LCDCS)=0        'assert bus
  LCDCOMMAND(&H2A)          'set columns
  LCDDATA((X0\256) AND 255) 'start
  LCDDATA(X0 AND 255)
  LCDDATA((X1\256) AND 255) 'end
  LCDDATA(X1 AND 255)
  LCDCOMMAND(&H2B)          'set row
  LCDDATA((Y0\256) AND 255) 'start
  LCDDATA(Y0 AND 255)
  LCDDATA((Y1\256) AND 255) 'end
  LCDDATA(Y1 AND 255)
  LCDCOMMAND(&h2C)          ''draw
  PIN(LCDCS)=1        'release bus
END SUB
  
SUB LCDSETROTATION(R AS INTEGER)
  IF R = 0 THEN
    LCDROTATION=0
    LCDWIDTH=320
    LCDHEIGHT=480
    PIN(LCDCS)=0        'assert bus
    LCDCOMMAND(&H36)    'MA control
    LCDDATA(88)
    LCDSETAREA(0,0,LCDWIDTH-1,LCDHEIGHT-1)
    PIN(LCDCS)=1        'release bus
  ENDIF
  IF R = 1 THEN
    LCDROTATION=1
    LCDWIDTH=480
    LCDHEIGHT=320
    PIN(LCDCS)=0        'assert bus
    LCDCOMMAND(&H36)    'MA control
    LCDDATA(56)
    LCDSETAREA(0,0,LCDWIDTH-1,LCDHEIGHT-1)
    PIN(LCDCS)=1        'release bus
  ENDIF
  IF R = 2 THEN
    LCDROTATION=2
    LCDWIDTH=320
    LCDHEIGHT=480
    PIN(LCDCS)=0        'assert bus
    LCDCOMMAND(&H36)    'MA control
    LCDDATA(152)
    LCDSETAREA(0,0,LCDWIDTH-1,LCDHEIGHT-1)
    PIN(LCDCS)=1        'release bus
  ENDIF
  IF R = 3 THEN
    LCDROTATION=3
    LCDWIDTH=480
    LCDHEIGHT=320
    PIN(LCDCS)=0        'assert bus
    LCDCOMMAND(&H36)    'MA control
    LCDDATA(248)
    LCDSETAREA(0,0,LCDWIDTH-1,LCDHEIGHT-1)
    PIN(LCDCS)=1        'release bus
  ENDIF
END SUB
  
SUB LCDPOINT(X AS INTEGER, Y AS INTEGER, C AS INTEGER)
  LCDSETAREA(X,Y,X,Y)
  LOCAL INTEGER C0,C1,C2
  C2=(C\65536)AND 255     'calculate here
  C1=(C\256)AND 255
  C0=C AND 255
  PIN(LCDCS)=0        'assert bus
  LCDCOLOUR(C2,C1,C0)
  PIN(LCDCS)=1        'release bus
END SUB

SUB LCDCHAR(X AS INTEGER, Y AS INTEGER, C$ AS STRING, F AS INTEGER, B AS INTEGER) 'display a single character
  LOCAL INTEGER T,U,V,CP
  LOCAL INTEGER BIT,BYTE
  LOCAL INTEGER F0,F1,F2
  LOCAL INTEGER B0,B1,B2
  F2=(F\65536)AND 255     'calculate here
  F1=(F\256)AND 255
  F0=F AND 255
  B2=(B\65536)AND 255     'calculate here
  B1=(B\256)AND 255
  B0=B AND 255
  CP=asc(C$)-32
  IF CP<0 THEN CP=0
  IF CP>95 THEN CP=0
  FOR T = 0 TO 573 STEP 3   'assume background
    CBUFFER(T)=B2
    CBUFFER(T+1)=B1
    CBUFFER(T+2)=B0
  NEXT T
  for T = 0 to 23
    FONTARRAY(T)=PEEK(BYTE T+FONTADDRESS+CP*24)
  NEXT T
  FOR V = 0 TO 15
    BIT=BITS(V MOD 8)
    BYTE=V\8
    for U = 0 to 11
      if (FONTARRAY(BYTE+U*2) AND BIT) >0 THEN  'otherwise foreground
        CBUFFER(U*3+V*36)=F2
        CBUFFER(U*3+V*36+1)=F1
        CBUFFER(U*3+V*36+2)=F0
      ENDIF
    NEXT U
  NEXT V
  LCDSETAREA(X,Y,X+11,Y+15)
  PIN(LCDCS)=0        'assert bus
  LCDCOLOUR80(CBUFFER())
  PIN(LCDCS)=1        'release bus
END SUB

SUB LCDSTRING(X AS INTEGER, Y AS INTEGER, C$ AS STRING, F AS INTEGER, B AS INTEGER) 'display a string using LCDCHAR
  IF LEN(C$)=0 THEN EXIT SUB
  LOCAL INTEGER T
  FOR T = 1 TO LEN(C$)
    LCDCHAR(X,Y,mid$(C$,T,1),F,B)
    X=X+12
    if X > LCDWIDTH-12 THEN
      X=0
      Y=Y+16
    ENDIF
  NEXT T
END SUB

  ''font data, 12x16, each line is 192 bits arranged as 4 nybble vertical slices in order
CFunction FONT      'not an actual CFUNCTION, but an array to read data direct from flash
  00000000    ''offset in 32bit words, set to zero to start below
  'data starts here
  00000000 00000000 00000000 00000000 00000000 00000000 '           // 
  00000000 007C0000 33FF33FF 0000007C 00000000 00000000 '           //!
  00000000 003C003C 00000000 003C003C 00000000 00000000 '           //"
  1E100200 03F01F90 1E1E027E 03F01F90 001E027E 00000010 '           //#
  04780000 0CCC0CFC 3FFF3FFF 0FCC0CCC 00000788 00000000 '           //$
  38383000 0E381C38 03800700 38E001C0 38383870 0000001C '           //%
  1F000000 31FC3FB8 37E221C6 1C1C1E3E 22003600 00000000 '           //&
  00000000 00270000 001F003F 00000000 00000000 00000000 '           //'
  00000000 0FFC03F0 38071FFE 20012001 00000000 00000000 '           //(
  00000000 20012001 1FFE3807 03F00FFC 00000000 00000000 '           //)
  0C980000 03E00EB8 0FF80FF8 0EB803E0 00000C98 00000000 '           //*
  01800000 01800180 0FF00FF0 01800180 00000180 00000000 '           //+
  00000000 B8000000 7800F800 00000000 00000000 00000000 '           //
  01800000 01800180 01800180 01800180 00000180 00000000 '           //-
  00000000 38000000 38003800 00000000 00000000 00000000 '           //.
  1C001800 07000E00 01C00380 007000E0 001C0038 0000000E '           ///
  1FFE07F8 33031E06 30C33183 30333063 1FFE181E 000007F8 '0
  00000000 300C300C 3FFF300E 30003FFF 30003000 00000000 '1
  381E301C 3E033C07 33833703 30E331C3 303E3077 0000301C '2
  1C0E0C0C 30C33807 30C330C3 30C330C3 1F7E39E7 00000E3C '3
  03E003C0 03380370 030E031C 3FFF0307 03003FFF 00000300 '4
  1C7F0C3F 30633863 30633063 30633063 1FC338E3 00000F83 '5
  1FF00FC0 30DC39F8 30C730CE 30C330C3 1F8039C3 00000F00 '6
  00030003 30030003 0F033C03 00F303C3 000F003F 00000003 '7
  1FBC0F00 30E739FE 30C330C3 30E730C3 1FBC39FE 00000F00 '8
  007E003C 30C330E7 38C330C3 0EC31CC3 03FE07E7 000000FC '9
  00000000 1C700000 1C701C70 00000000 00000000 00000000 '           //:
  00000000 9C700000 7C70FC70 00000000 00000000 00000000 '           //;
  00C00000 03F001E0 0E1C0738 38071C0E 00003003 00000000 '           //<
  06600000 06600660 06600660 06600660 06600660 00000000 '           //=
  30030000 1C0E3807 07380E1C 01E003F0 000000C0 00000000 '           //>
  001E001C 00030007 37C33783 007700E3 001C003E 00000000 '           //?
  1FFE0FF8 33F31807 361B37FB 37FB37FB 03FE3607 000001F8 '           //@
  3F003800 06FC07E0 061F061F 07E006FC 38003F00 00000000 '           //A
  3FFF3FFF 30C330C3 30C330C3 39FE30E7 0F001FBC 00000000 '           //B
  0FFC03F0 38071C0E 30033003 38073003 0C0C1C0E 00000000 '           //C
  3FFF3FFF 30033003 30033003 1C0E3807 03F00FFC 00000000 '           //D
  3FFF3FFF 30C330C3 30C330C3 30C330C3 30033003 00000000 '           //E
  3FFF3FFF 00C300C3 00C300C3 00C300C3 00030003 00000000 '           //F
  0FFC03F0 38071C0E 30C33003 30C330C3 3FC63FC7 00000000 '           //G
  3FFF3FFF 00C000C0 00C000C0 00C000C0 3FFF3FFF 00000000 '           //H
  00000000 30033003 3FFF3FFF 30033003 00000000 00000000 '           //I
  1E000E00 30003800 30003000 38003000 07FF1FFF 00000000 '           //J
  3FFF3FFF 01E000C0 073803F0 1C0E0E1C 30033807 00000000 '           //K
  3FFF3FFF 30003000 30003000 30003000 30003000 00000000 '           //L
  3FFF3FFF 0078001E 01E001E0 001E0078 3FFF3FFF 00000000 '           //M
  3FFF3FFF 0038000E 03C000F0 1C000700 3FFF3FFF 00000000 '           //N
  0FFC03F0 38071C0E 30033003 1C0E3807 03F00FFC 00000000 '           //O
  3FFF3FFF 01830183 01830183 01C70183 007C00FE 00000000 '           //P
  0FFC03F0 38071C0E 36033003 1C0E3E07 33F03FFC 00000000 '           //Q
  3FFF3FFF 01830183 07830383 1DC70F83 307C38FE 00000000 '           //R
  1C7E0C3C 30C338E7 30C330C3 39C730C3 0F0C1F8E 00000000 '           //S
  00030000 00030003 3FFF3FFF 00030003 00000003 00000000 '           //T
  1FFF07FF 30003800 30003000 38003000 07FF1FFF 00000000 '           //U
  003F0007 0FC001F8 3E003E00 01F80FC0 0007003F 00000000 '           //V
  3FFF3FFF 06001C00 03800380 1C000600 3FFF3FFF 00000000 '           //W
  3C0F3003 03300E1C 01E001E0 0E1C0330 30033C0F 00000000 '           //X
  000F0003 00F0003C 3FC03FC0 003C00F0 0003000F 00000000 '           //Y
  3C033003 33033E03 30E331C3 301F3033 3003300F 00000000 '           //Z
  00000000 3FFF3FFF 30033003 30033003 00000000 00000000 '           //[
  001C000E 00700038 01C000E0 07000380 1C000E00 00001800 '           //backslash
  00000000 30033003 30033003 3FFF3FFF 00000000 00000000 '           //]
  00700060 001C0038 0007000E 001C000E 00700038 00000060 '           //^
  C000C000 C000C000 C000C000 C000C000 C000C000 0000C000 '           //_
  00000000 00000000 007E003E 0000004E 00000000 00000000 '           //`
  3E401C00 33603360 33603360 33603360 3FC03FE0 00000000 '           //a
  3FFF3FFF 306030C0 30603060 38E03060 0F801FC0 00000000 '           //b
  1FC00F80 306038E0 30603060 30603060 088018C0 00000000 '           //c
  1FC00F80 306038E0 30603060 30C030E0 3FFF3FFF 00000000 '           //d
  1FC00F80 33603BE0 33603360 33603360 018013C0 00000000 '           //e
  00C000C0 3FFE3FFC 00C300C7 000300C3 00000000 00000000 '           //f
  C7C00380 CC60CEE0 CC60CC60 E660CC60 3FE07FE0 00000000 '           //g
  3FFF3FFF 006000C0 00600060 3FC000E0 00003F80 00000000 '           //h
  00000000 30603000 3FEC3FEC 30003000 00000000 00000000 '           //i
  00000000 E0006000 C060C000 7FECFFEC 00000000 00000000 '           //j
  3FFF0000 03003FFF 0FC00780 38601CE0 00003000 00000000 '           //k
  00000000 30033000 3FFF3FFF 30003000 00000000 00000000 '           //l
  3FC03FE0 00E000E0 3FC03FC0 00E000E0 3F803FC0 00000000 '           //m
  3FE00000 00603FE0 00600060 00E00060 3F803FC0 00000000 '           //n
  1FC00F80 306038E0 30603060 38E03060 0F801FC0 00000000 '           //o
  FFE0FFE0 18600C60 18601860 1CE01860 07800FC0 00000000 '           //p
  0FC00780 18601CE0 18601860 0C601860 FFE0FFE0 00000000 '           //q
  3FE00000 00C03FE0 00600060 00600060 00C000E0 00000000 '           //r
  33E011C0 33603360 33603360 1E403F60 00000000 00000000 '           //s
  00600060 3FFE1FFE 30603060 30003060 00000000 00000000 '           //t
  1FE00FE0 30003800 30003000 18003000 3FE03FE0 00000000 '           //u
  01E00060 1E000780 38003800 07801E00 006001E0 00000000 '           //v
  1FE007E0 1C003800 0FE00FE0 38001C00 07E01FE0 00000000 '           //w
  38E03060 0F801DC0 0F800700 38E01DC0 00003060 00000000 '           //x
  00600000 E78081E0 1E007E00 01E00780 00000060 00000000 '           //y
  38603060 36603C60 31E03360 306030E0 00003020 00000000 '           //z
  00800000 1FFC01C0 70073F7E 60036003 00006003 00000000 '           //{
  00000000 00000000 3FFF3FFF 00000000 00000000 00000000 '           //|
  60030000 60036003 3F7E7007 01C01FFC 00000080 00000000 '           //}
  00180010 0004000C 0018000C 00180010 0004000C 00000000 '           //~
  07000100 78001E00 1E007800 01E00780 001C0078 00030006 '
End CFunction
